clear *;clc;close all
A=1;k=10^6;%k: Number of symbols for the simulation
EbpN0dB=-2:20;EbpN0dB=EbpN0dB';%(Eb/N0)db and (Eb/N0) array
EbpN0=10.^(0.1*EbpN0dB);
N0p2=A^2./EbpN0;%Evaluate N0/2=sigma^2 for the duobinary signal. Notice that Eb=0.25*(2A)^2+0.5*0+0.25*(-2A)^2
%Evaluate Performanc for Duobinary and 2-PAM
ber=zeros(length(EbpN0dB),1);v=zeros(length(EbpN0dB),1);%Alocate memory for arrays
ber=[10^-5,5*10^-5,10^-4,5*10^-4,10^-3,5*10^-3,10^-2,5*10^-2,0.1,0.2];
EbpN0pc=(4/pi)^2/2*[qfuncinv((2/3).*ber)].^2;%The relationship for duobinary  
EbpN0bpam=[qfuncinv(ber)].^2/2;%The relationship for 2-PAM 
semilogy(10*log10(EbpN0pc),ber,'r');hold on;%Plot duobinary performance
semilogy(10*log10(EbpN0bpam),ber,'g')%Plot 2-PAM performance
%
% Evaluate performance for Maximum likelihood sequence
a = randsrc(1,k,[A,-A]);%k symbols
%Evaluate noiseles output of the channel duobinary signal
y=zeros(1,length(a));
y(1)=a(1);
for i=2:length(a)
    y(i)=a(i)+a(i-1);
end
%For an array of sigma^2 values evaluate performanc of ML SEQ
for i=1:length(EbpN0dB)-10
    yn=y+sqrt(N0p2(i))*randn(1,k);
    q=mlseeq(yn,[1,1],[A,-A],8,'rst');
    cc=find(q~=a);nerror=length(cc);
    ber(i)=nerror/k;
end
semilogy(EbpN0dB(1:length(ber)),ber,'k')%Plot Performance of    ML SEQ 
%Evaluate Performance of MSEE equalizr on duobinary signal for diferent
%lengths of equalizers
for N2p1=5:2:11
    %For given length of equalizer evaluate Amatrix and b vector
    Amatrix=zeros(N2p1);b=zeros(N2p1,1);
    ind=(N2p1-1)/2;
    b(ind+1:ind+2)=1;
    for index=1:N2p1-1;
        Amatrix(index+1,index)=1;
        Amatrix(index,index+1)=1;
    end
    %For array of sigma^2 values evaluate performance
for i=1:length(EbpN0dB) 
    %Update Amatrix according tou sigma^2
a0=2+N0p2(i);
for index=1:N2p1;
    Amatrix(index,index)=a0;
end
C=Amatrix\b;%Evaluate cofficients
%construct 2-PAm signal
a = randsrc(1,k,[A,-A]);
y=conv(a,[1,1])+sqrt(N0p2(i))*randn(1,k+1);
z=conv(y,C);%Evaluate equalizer output 
z=z(ind+2:ind+2+k-1);
v(i)=var((z-a));
ad=sign(z);%decide for signal
cc=find(ad~=a);nerror=length(cc);%Measure ber
ber(i)=nerror/k;
end
semilogy(EbpN0dB,ber)
end

grid;
xlabel('(E_b/N_0)_{dB}');ylabel('P_b')%Plot Performance
hold off
legend('procoded Duobinary','2-PAM','Duobinary ML SEQ','Duobinary 5,7,9,11 MMSE Equalizer')
