clear *;close all;clc;
N=1000000;
EbpN0dB=3:18;EbpN0dB=EbpN0dB';
EbpN0=10.^(0.1*EbpN0dB);
% Construct a modulator object for 4-PAM modulation.
h = modem.pammod('M', 4);
a = modulate(h, [0,0,randint(1,N,4)]);%N+2 pulses of 4-PAM
% Construct Noiseles Signal through the cannel 
y=zeros(1,length(a));
y(1)=a(1);y(2)=a(2)+0.8*a(1);
for i=3:length(a)
    y(i)=a(i)+0.8*a(i-1)-0.2*a(i-2);
end
%Construct noisy channel Signal for different values of EbpN0
for i=1:length(EbpN0)
Eb(i)=var(y)/2;%Evaluate Eb
N0p2(i)=Eb(i)/2/EbpN0(i);%Evaluate N0/2=sigma^2
yn=y+sqrt(N0p2(i))*randn(1,length(y));%consttruct noisy channel signal
q=mlseeq(yn,[1,0.8, -0.2],[-3, -1, 1, 3],6,'rst');%Deconvolution
[num_sym,ratio_sym(i)] = symerr(a,q);%Evaluate symbol error rate
end
semilogy(EbpN0dB,ratio_sym);hold on;%Plot Maximum Likelihood Performance
% Evaluate and plot teoritical Performance
logPe=-5:0.4:-1;serth=10.^logPe;
EbpN0th=5/4*qfuncinv(2/3*serth).^2;%Theoretical relation
EbpN0thdB=10*log10(EbpN0th);
semilogy(EbpN0thdB,serth,'r')
grid;
ylabel('P_e');xlabel('(E_b/N_0)_{dB}');
legend('4-PAM ML-SEQ','4-PAM no ISI')