# The Dummy SoC
The Dummy SoC is a simple design containing the "dummy" peripheral. This peripheral uses the AXI DMA IP Core to read N_in 32-bit tokens and write back N_out tokens respectively, where N_in >= N_out. Reads and writes are done concurrently through the physically separated HP0 and HP2 ZYNQ7 ports.

You can either use pre-built components to run the dummy project or generate the entire project from scratch using the provided automated scripts.

# Flow 1: Use the pre-built components.

Use the pre-built system components and compile the provided source code using the ./config-sd.sh shell script located in the ./build directory.

Insert a properly formatted SD card into your computer and run:

```shell
    $./config-sd /full/path/to/dummy-project
```

Use the SD card to bring up the board. Within your PetaLinux OS, navigate to /test/ and run the test_run.sh script. Open the generated log.txt file to see the output.

# Flow 2: Create the PetaLinux OS from scratch using pre-built hardware components.

You can build the entire system from scratch using the pre-built hardware provided by running a single script.

In ./hardware, the pre-built.xsa file contains all the hardware components required for the Dummy SoC design. In the ./build directory, run the ./config-os.sh script:

``` shell
    $./config-os /full/path/to/tools/petalinux/settings.sh /full/path/to/dummy-project dummy-soc
```

Let the system to generate all the required components. Once completed, a new folder named image will be created in your project folder and populated with the boot components. Edit ./config-sd.sh, comment out image_path="$path/prebuilt-image", and uncomment image_path="$path/image".

Insert a properly formatted SD card into your computer and run:

```shell
    $./config-sd /full/path/to/dummy-project
```

Use the SD card to bring up the board. Within your PetaLinux OS, navigate to /test/ and run the test_run.sh script. Open the generated log.txt file to see the output.

# Flow 3: Build everything from scratch

Use the source code and TCL script in ./hardware to generate the hardware components from scratch. Replace the pre-built.xsa with the newly generated one.

In the ./build directory, run the ./config-os.sh script:

``` shell
    $./config-os full/path/to/tools/petalinux/settings.sh /full/path/to/dummy-project dummy-soc
```

Let the system to generate all the required components. Once completed, a new folder named image will be created in your project folder and populated with the boot components. Edit ./config-sd.sh, comment out image_path="$path/prebuilt-image", and uncomment image_path="$path/image".

Insert a properly formatted SD card into your computer and run:

```shell
    $./config-sd /full/path/to/dummy-project
```

Use the SD card to bring up the board. Within your PetaLinux OS, navigate to /test/ and run the test_run.sh script. Open the generated log.txt file to see the output.

# Notes:
1. Open the Makefiles in ./autotest and ./src and replace the path to the ARM Linux compiler with your own.
2. The programs test_gen and dummy-worker are located in /usr/bin of your PetaLinux system.

# Folders:
1. `autotest`: Contains the components used to test the design.
2. `build`: Contains the components such as the device tree and drivers source code, and scripts used to generate and build a PetaLinux system.
3. `hardware`: Contains the hardware components required to build the system or regenerate the hardware.
4. `prebuilt-image`: Contains pre-built and tested images for the Dummy SoC.
5. `src`: Contains the Dummy Worker source code.
