/*
 * Creator      : Ronaldo Tsela
 * Description  : Populate a file with pseudo-random values.
 * Compilation  : gcc -g -Wall -o test-gen test_gen.c
 * Run          : ./test-gen <filename> <size in words> <upper integer value> <lower integer value>
 * Input        : filename : The file (.raw) to create
 *                size in words : The size of the files in words (32-bit)
 *                upper integer value : The upper bound
 *                lower integer value : The lower bound
 * Output       : A file populated with bytes
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdint.h>
#include <fcntl.h>
#include <time.h>

//#define DEBUG_ON

int main(int argc, char *argv[]) {
    if (argc != 5) {
        printf("Usage: %s <filename> <size in words> <upper integer value> <lower integer value>\n", argv[0]);
        exit(1);
    }

    int *data, fd_out, i;

    char *fout_name = (char *)argv[1];
    int N   = strtol(argv[2], NULL, 10);
    int max = strtol(argv[3], NULL, 10);
    int min = strtol(argv[4], NULL, 10);

    if ((fd_out = open(fout_name, O_WRONLY | O_CREAT, 0666)) == -1) {
        printf("[ERR] Cannot create the file %s. Exiting\n", fout_name);
        exit(1);
    }

    data = (int *)malloc(N * sizeof(int));

/***/
    printf("[INFO] Populating %s with %d bytes...\n", fout_name, N * sizeof(int));

    srand(time(NULL));

    for (i = 0; i < N; i++) {
        data[i] = rand() % (max - min + 1) + min;

#ifdef DEBUG_ON // print the values
        if (i == 0)
            printf("\n%d, ", data[i]);
        else if (i == N - 1)
            printf("%d\n", data[i]);
        else
            printf("%d, ", data[i]);
#endif
    }

    write(fd_out, data, N * sizeof(int));

    printf("[INFO] %d bytes writen in %s\n", N * sizeof(int), fout_name);

    close(fd_out);
    free(data);
/***/

#ifdef DEBUG_ON // Read the file just populated
    data = (int *)malloc(N * sizeof(int));

    if ((fd_out = open(fout_name, O_RDONLY)) == -1) {
        printf("[ERR] Cannot open file %s. Exiting\n", fout_name);
        exit(1);
    }

    int n = read(fd_out, data, N * sizeof(int));
    printf("Read %d bytes\n", n);

    for (i = 0; i < (n / sizeof(int)); i++) {
        if (i == 0)
            printf("\n%d, ", data[i]);
        else if (i == N - 1)
            printf("%d\n", data[i]);
        else
            printf("%d, ", data[i]);
    }

    close(fd_out);
    free(data);
#endif

    return 0;
}
