#!/usr/bin/bash
# Creator 	     : Ronaldo Tsela
# Description 	 : This script is used to configure a basic PetaLinux OS image including the DMA Proxy module used for Dummy soc.
# Usage		     : ./config-os.sh <PetaLinux tools path> <Project path> <System name>
# Input		     : Petalinux tools path : the path to the PetaLinux tools installation
#		         : Project path : the full path to the current project file
#                : System name  : the name that will be used for the PetaLinux OS
# Output	     : Creates a folder ./image where the PetaLinux boot components for Dummy soc are placed

if [ -z "$1" ] || [ -z "$2" ] || [ -z "$3" ]; then
    echo "Usage : $0 <PetaLinux tools path> <project path> <system name>"
    exit 1
fi

tools_path="$1"
proj_path="$2"
name="$3"

# Source the PetaLinux tools
source "$tools_path/settings.sh"

cd "$proj_path"

# Create a new PetaLinux OS project
petalinux-create --type project --name $name --template zynq --force
cd ./$name

# Configure the OS on static BSP
petalinux-config --get-hw-description="$proj_path/hardware"

# First build. This will take some time...
petalinux-build

# Create the DMA Proxy Module
petalinux-create --type modules --name dma-proxy --enable --force

# Copy the source code and device tree for the DMA Proxy Module
cp $proj_path/build/dma-proxy.* ./project-spec/meta-user/recipes-modules/dma-proxy/files
cp $proj_path/build/system-user.dtsi ./project-spec/meta-user/recipes-bsp/device-tree/files

# Configure the .bb Yocto recipe file
echo "13i" > cmd.txt
echo "file://dma-proxy.h \ " >> cmd.txt
echo "." >> cmd.txt
echo "w" >> cmd.txt
echo "q" >> cmd.txt

ed ./project-spec/meta-user/recipes-modules/dma-proxy/dma-proxy.bb < cmd.txt

rm cmd.txt

# Second build to include the module.
petalinux-build

# Package the boot components
petalinux-package --boot --force --fsbl ./images/linux/zynq_fsbl.elf --fpga ./images/linux/system.bit --uboot ./images/linux/u-boot.elf

# Export the boot components
mkdir -p $proj_path/image
cp ./images/linux/BOOT.BIN ./images/linux/boot.scr ./images/linux/system.dtb ./images/linux/image.ub ./images/linux/rootfs.tar.gz $proj_path/image
