library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity dummy_tb is
end dummy_tb;

architecture behv of dummy_tb is
    constant C_CLOCK_PERIOD : time := 10 ns;
    constant C_DATA_WIDTH   : integer := 32;
    constant C_N_IN         : integer := 20;
    constant C_N_OUT        : integer := 13;
    
    signal en               : std_logic := '0';
    signal N_in             : std_logic_vector(31 downto 0) := std_logic_vector(to_unsigned(C_N_IN, 32));
    signal N_out            : std_logic_vector(31 downto 0) := std_logic_vector(to_unsigned(C_N_OUT, 32));
    
    signal aclk             : std_logic := '0';
    signal aresetn          : std_logic := '0';
    
    signal s_axis_tdata     : std_logic_vector(C_DATA_WIDTH-1 downto 0) := (others => '0');
    signal s_axis_tvalid    : std_logic := '0';
    signal s_axis_tlast     : std_logic := '0'; 
    signal s_axis_tready    : std_logic;

    signal m_axis_tdata     : std_logic_vector(C_DATA_WIDTH-1 downto 0);
    signal m_axis_tvalid    : std_logic;
    signal m_axis_tlast     : std_logic;
    signal m_axis_tready    : std_logic := '0';

    signal read_en          : std_logic := '0';
begin
    -- Instantiate the Unit Under Test (UUT)
    uut: entity work.dummy
        generic map (
            C_DATA_WIDTH => C_DATA_WIDTH
        )
        port map (
            aclk            => aclk,
            aresetn         => aresetn,
            
            enable          => en,
            N_in            => N_in,
            N_out           => N_out,
            
            s_axis_tdata    => s_axis_tdata,
            s_axis_tvalid   => s_axis_tvalid,
            s_axis_tlast    => s_axis_tlast,
            s_axis_tready   => s_axis_tready,
          
            m_axis_tdata    => m_axis_tdata,
            m_axis_tvalid   => m_axis_tvalid,
            m_axis_tlast    => m_axis_tlast,
            m_axis_tready   => m_axis_tready
        );
    
    clock_gen : process
    begin
        wait for C_CLOCK_PERIOD / 2;
        aclk <= not aclk;
    end process;
    
    -- Stimulus process
    stimulus: process
    begin
        -- Reset the system
        s_axis_tlast  <= '0';
        s_axis_tvalid <= '0';
        s_axis_tlast  <= '0';
        
        read_en <= '0';
        en <= '1';
        
        aresetn <= '0';
        wait for C_CLOCK_PERIOD * 6;
        aresetn <= '1';

        -- Send N_in words of data
        s_axis_tvalid <= '1';
        for i in 0 to C_N_IN-1 loop
            s_axis_tdata <= std_logic_vector(to_unsigned(i, C_DATA_WIDTH));
            wait until s_axis_tready = '1' and rising_edge(aclk);
            
            read_en <= '1';
            
            if i = C_N_IN-1 then
                s_axis_tlast <= '1';
            else
                s_axis_tlast <= '0';
            end if;
            
        end loop;
        
        s_axis_tlast  <= '0'; 
        s_axis_tvalid <= '0';

        wait;
    end process;
    
    read_out : process
    begin
        wait until read_en = '1';
        m_axis_tready <= '1';
        
        for i in 0 to C_N_OUT-1 loop
            wait until m_axis_tvalid = '1' and rising_edge(aclk);
            report "Output data: " & integer'image(to_integer(unsigned(m_axis_tdata)));
        end loop;
        
        m_axis_tready <= '0';
        wait;
    end process;
end behv;
