library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity dummy_top is
Port (
     aclk, aresetn  : in std_logic;
     
     -- AXI4 Lite slave interface (configuration)
     s_axi_awaddr	: in std_logic_vector(3 downto 0);
     s_axi_awprot	: in std_logic_vector(2 downto 0);
     s_axi_awvalid	: in std_logic;
     s_axi_awready	: out std_logic;
    
     s_axi_wdata	: in std_logic_vector(31 downto 0);
     s_axi_wstrb	: in std_logic_vector(3 downto 0);
     s_axi_wvalid	: in std_logic;
     s_axi_wready	: out std_logic;
    
     s_axi_bresp	: out std_logic_vector(1 downto 0);
     s_axi_bvalid	: out std_logic;
     s_axi_bready	: in std_logic;
    
     s_axi_araddr	: in std_logic_vector(3 downto 0);
     s_axi_arprot	: in std_logic_vector(2 downto 0);
     s_axi_arvalid	: in std_logic;
     s_axi_arready	: out std_logic;
    
     s_axi_rdata	: out std_logic_vector(31 downto 0);
     s_axi_rresp	: out std_logic_vector(1 downto 0);
     s_axi_rvalid	: out std_logic;
     s_axi_rready	: in std_logic;
    
     -- AXI4 Stream slave interface (stream receiver)
     s_axis_tvalid  : in std_logic;
     s_axis_tready  : out std_logic;
     s_axis_tdata   : in std_logic_vector(31 DOWNTO 0);
     s_axis_tlast   : in std_logic;
    
     -- AXI4 Stream master interface (stream transmiter)
     m_axis_tvalid  : out std_logic;
     m_axis_tready  : in std_logic;
     m_axis_tdata   : out std_logic_vector(31 DOWNTO 0);
     m_axis_tlast   : out std_logic);
end dummy_top;

architecture Behavioral of dummy_top is
    component dummy is
    Generic ( C_DATA_WIDTH : integer := 32 );
    Port (
         aclk            : in std_logic;
         aresetn         : in std_logic;
         
         enable          : in std_logic;
         N_in            : in std_logic_vector(31 downto 0);
         N_out           : in std_logic_vector(31 downto 0);

         s_axis_tdata    : in  std_logic_vector(C_DATA_WIDTH-1 downto 0);
         s_axis_tvalid   : in  std_logic;
         s_axis_tlast    : in  std_logic;
         s_axis_tready   : out std_logic;

         m_axis_tdata    : out std_logic_vector(C_DATA_WIDTH-1 downto 0);
         m_axis_tvalid   : out std_logic;
         m_axis_tlast    : out std_logic;
         m_axis_tready   : in  std_logic );
    end component; 
     
    component dummy_regs is
        port (
            s_axi_aclk	    : in std_logic;
            s_axi_aresetn	: in std_logic;
            
            -- configuration registers
            enable          : out std_logic;
            N_in            : out std_logic_vector(31 downto 0);
            N_out           : out std_logic_vector(31 downto 0);
        
            -- AXI4 Lite Interface
            s_axi_awaddr	: in std_logic_vector(3 downto 0);
            s_axi_awprot	: in std_logic_vector(2 downto 0);
            s_axi_awvalid	: in std_logic;
            s_axi_awready	: out std_logic;
            
            s_axi_wdata	    : in std_logic_vector(31 downto 0);
            s_axi_wstrb	    : in std_logic_vector(3 downto 0);
            s_axi_wvalid	: in std_logic;
            s_axi_wready	: out std_logic;
            
            s_axi_bresp	    : out std_logic_vector(1 downto 0);
            s_axi_bvalid	: out std_logic;
            s_axi_bready	: in std_logic;
            
            s_axi_araddr	: in std_logic_vector(3 downto 0);
            s_axi_arprot	: in std_logic_vector(2 downto 0);
            s_axi_arvalid	: in std_logic;
            s_axi_arready	: out std_logic;
            
            s_axi_rdata	    : out std_logic_vector(31 downto 0);
            s_axi_rresp	    : out std_logic_vector(1 downto 0);
            s_axi_rvalid	: out std_logic;
            s_axi_rready	: in std_logic
        );
    end component;
    
    signal enable : std_logic := '0'; 
    signal N_in   : std_logic_vector(31 downto 0) := (others=>'0');
    signal N_out  : std_logic_vector(31 downto 0) := (others=>'0');
begin

-- Configuration interface. Write the nuber of words to read from core memory and the
-- number of words to write back to core memory.
configuration_regs : dummy_regs
port map(
    s_axi_aclk      => aclk,
    s_axi_aresetn   => aresetn, 
    
    enable          => enable,
    N_in            => N_in,
    N_out           => N_out,
    
    s_axi_awaddr    => s_axi_awaddr,
    s_axi_awprot    => s_axi_awprot,
    s_axi_awvalid   => s_axi_awvalid,
    s_axi_awready   => s_axi_awready,
    
    s_axi_wdata     => s_axi_wdata,
    s_axi_wstrb     => s_axi_wstrb,
    s_axi_wvalid    => s_axi_wvalid,
    s_axi_wready    => s_axi_wready,
    
    s_axi_bresp     => s_axi_bresp,
    s_axi_bvalid    => s_axi_bvalid,
    s_axi_bready    => s_axi_bready,
    
    s_axi_araddr    => s_axi_araddr,
    s_axi_arprot    => s_axi_arprot,
    s_axi_arvalid   => s_axi_arvalid,
    s_axi_arready   => s_axi_arready,
    
    s_axi_rdata     => s_axi_rdata,
    s_axi_rresp     => s_axi_rresp,
    s_axi_rvalid    => s_axi_rvalid,
    s_axi_rready    => s_axi_rready
);

-- Read data from the FIFO, make some operations and write them to another FIFO
device : dummy
port map(
    aclk             => aclk,
    aresetn          => aresetn,
    
    enable           => enable,
    N_in             => N_in,
    N_out            => N_out,
    
    s_axis_tready    => s_axis_tready,
    s_axis_tdata     => s_axis_tdata,
    s_axis_tlast     => s_axis_tlast,
    s_axis_tvalid    => s_axis_tvalid,
    
    m_axis_tready    => m_axis_tready,
    m_axis_tdata     => m_axis_tdata,
    m_axis_tlast     => m_axis_tlast,
    m_axis_tvalid    => m_axis_tvalid
);   

end Behavioral;