#ifndef _DUMMY_H_
#define _DUMMY_H_

#include "libpdpu.h"

#define C_TRANSFER_SIZE 	1024 * 32 // in bytes

/*
 * Register Address Space
 * 0x00 : reg N_in   -> number of words to read from PS
 * 0x04 : reg N_out  -> number of words to send back to PS
 * 0x08 : reg Enable -> enable or dissable the core
 * 0x0c : nop
 */
#define C_REG_BASE 			0x40000000
#define C_REG_SIZE 			( 4 * sizeof(uint32_t) )

#define C_FIRMWARE_BIN		"/lib/firmware/xilinx/dummy-firmware/*.bin"
#define C_FIRMWARE_DTBO		"/lib/firmware/xilinx/dummy-firmware/*.dtbo"

typedef struct {
	Channel *channel;
	char *file;
	uint32_t transfer_size;
	uint32_t total_size;
	uint32_t status;
	int *halt_op;
}dma_thread_args;

void *ps2pl (void *args);
void *pl2ps (void *args);

#endif
