#ifndef _LIBPDPU_H_
#define _LIBPDPU_H_

#include <pthread.h>
#include <stdint.h>
#include "dma-proxy.h"

#define OK 	0
#define ERR 1

#define TX_CHANNEL_NAME "dma_proxy_tx_0"
#define RX_CHANNEL_NAME "dma_proxy_rx_0"

typedef struct{
	struct channel_buffer *buf_ptr;
	char *name;
	int fd;
	pthread_t tid;
	pthread_t ret;
}Channel;

typedef struct{
	uint32_t base;
	uint32_t *ptr;
	uint32_t size;	
}AXILite_Register;

void AXILite_Register_Write(uint32_t *reg, uint32_t offset, uint32_t data);
uint32_t AXILite_Register_Read(uint32_t *reg, uint32_t offset);
int AXI_DMA_Init(Channel *channel);
void program_fpga(char *firmware_bin, char *firware_dtbo);

#endif
