----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date: 11/28/2020 06:40:32 PM
-- Design Name: 
-- Module Name: ALU_tb - Behavioral
-- Project Name: 
-- Target Devices: 
-- Tool Versions: 
-- Description: 
-- 
-- Dependencies: 
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx leaf cells in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity ALU_tb is
--  Port ( );
end ALU_tb;

architecture Behavioral of ALU_tb is

component ALU is
    Port ( a        : in STD_LOGIC_VECTOR (2 downto 0);
           b        : in STD_LOGIC_VECTOR (2 downto 0);
           Ctr      : in STD_LOGIC;
           Result   : out STD_LOGIC_VECTOR (2 downto 0);
           Carry    : out STD_LOGIC
         );
end component ALU;

signal a_tb      : STD_LOGIC_VECTOR (2 downto 0);  
signal b_tb      : STD_LOGIC_VECTOR (2 downto 0); 
signal Ctr_tb    : STD_LOGIC;                     
signal Result_tb : STD_LOGIC_VECTOR (2 downto 0);
signal Carry_tb  : STD_LOGIC;                                         



begin

-- Two valid ways to map ports to internal signals

--    Vertion 1 of declaring a port map
--    uut: ALU port map ( a=>a_tb,
--                        b=>b_tb,
--                        Ctr=>Ctr_tb,
--                        Result=>Result_tb, 
--                        Carry=>Carry_tb
--                       );

--    Vertion 2 of declaring a port map
    uut: ALU port map (a_tb,b_tb,Ctr_tb,Result_tb, Carry_tb);


-- TEST CODE

------------------------------------------------------
-- Version 1: test all combinations
test: process is
begin

Ctr_tb<='0';
a: for i in 0  to 7 loop
    a_tb<=std_logic_vector(to_unsigned(i,a_tb'length));
b:   for j in 0 to 7 loop
        b_tb<=std_logic_vector(to_unsigned(j,a_tb'length));wait for 10ns;
    end loop b;
end loop a;    

Ctr_tb<='1';
c: for i in 0  to 7 loop
    a_tb<=std_logic_vector(to_unsigned(i,a_tb'length));wait for 10ns;
end loop c;    

end process test;



end architecture Behavioral;
