library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity Counter is
port (
      clk                   : in std_logic;
      reset                 : in std_logic;
      direction             : in std_logic;
      load                  : in std_logic;
      load_data             : in std_logic_vector(3 downto 0);
      led_result            : out std_logic_vector(3 downto 0) -- LED Result input

    );
end entity Counter;

architecture Behavioral of Counter is

signal clk_one_sec: std_logic;                             --NEW CLOCK. Ticks every sec  --OK
signal new_clk_counts:  integer:=0;
signal clk_counts:     integer:=0; 
signal counts:      unsigned(3 downto 0):=(others=>'0');                      --Running timer value
signal new_counts: unsigned(3 downto 0):=(others=>'0'); 


begin

--FIRST LOGIC CIRCUIT
--COUNTS UPTO 100M clock ticks

--1st Part of First Circuit: INPUT
--Combinational input of Register
new_clk_counts<=clk_counts+1 when clk_counts<100000000 else 0;
--new_clk_counts<=clk_counts+1 when clk_counts<10 else 0;

--2nd Part of First Circuit: STATE (Register)
--The Register
--HOLD the clock's ticks!
counts_100M : process (clk, reset) is

variable clk_ticks : integer;

begin
    
	if reset = '1' then
	
	   clk_counts<=0;
       
	elsif rising_edge(clk) then

		clk_counts<=new_clk_counts;
		
	end if; --reset
    
end process counts_100M;

--3rd Part of First  Circuit: OUTPUT
--Compinational OUTPUT

clk_one_sec<='1' when clk_counts=100000000 else '0';

--SECOND LOGIC CIRCUIT
--COUNTS UP/DOWN seconds

--1st Part of Second Circuit: INPUT

process(clk_one_sec) is

begin

if (clk_one_sec='1') then 
--    report("1st counts"&integer'image(counts));
    if load='1' then 
        new_counts<=unsigned(load_data);
    else
        if (direction='1' and counts<15) then 
            new_counts<= counts+1; 
        elsif  (direction='0' and counts>0) then
            new_counts<= counts-1;
        elsif  (direction='0' and counts<=0) then
            new_counts<= "1111"; 
        elsif (direction='1' and counts>=15) then
            new_counts<="0000"; 
        else
            new_counts<="0000";	
        end if;
    end if;
--    report("2nd counts"&integer'image(counts));   
else
    new_counts<=counts;
end if;

end process;

--2nd Part of Second Circuit: STATE (Register)
--The Register
--HOLD the seconds!
                 
count_seconds: process (clk, reset) is

begin

if (reset='1') then

    counts<=(others=>'0');
--counts<=0;
elsif rising_edge(clk) then

    counts<=new_counts;

end if; --reset

end process count_seconds;

--3rd Part of Second  Circuit: OUTPUT
--Compinational OUTPUT


--LED Output
led_result<=std_logic_vector(counts);      


end Behavioral;

