library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity Counter is
port (
      clk                   : in std_logic;
      reset                 : in std_logic;
      direction             : in std_logic;
      led_result            : out std_logic_vector(6 downto 0); -- LED Result input
      seven_segment         : out std_logic_vector(6 downto 0); -- 7-segment output MSBit is g, LSBit is a
      digit_selection_out   : out std_logic                     -- Digit Selection OUT Pin for PmodSSD
    );
end entity Counter;

architecture Behavioral of Counter is

signal clk_one_sec: std_logic;                             --NEW CLOCK. Value='1' every sec  --
signal new_clk_counts:  integer:=0;
signal clk_counts:      integer:=0; 
signal sec_counts:      unsigned(6 downto 0):=(others=>'0');
signal new_sec_counts:  unsigned(6 downto 0):=(others=>'0');
signal right_digit: unsigned(3 downto 0):=(others=>'0');                      --Right digit in decimal
signal left_digit: unsigned(3 downto 0):=(others=>'0');                      --Left digit in decimal
signal seven_segment_left: std_logic_vector(6 downto 0);  
signal seven_segment_right: std_logic_vector(6 downto 0); --Right Pmod Digit 
signal digit_selection: std_logic:='0';

begin

------------------------------
------------------------------

--FIRST LOGIC CIRCUIT
--COUNTS UPTO 100M clock ticks

--1st Part of First Circuit: INPUT
--Combinational input of Register
new_clk_counts<=clk_counts+1 when clk_counts<100000000 else 0;
--new_clk_counts<=clk_counts+1 when clk_counts<10 else 0; --For simulation

--2nd Part of First Circuit: STATE (Register)
--The Register
--HOLD the clock's ticks!

counts_100M : process (clk, reset) is

begin
    
	if reset = '1' then
	
	   clk_counts<=0;
       
	elsif rising_edge(clk) then

		clk_counts<=new_clk_counts;
		
	end if; --reset
    
end process counts_100M;

--3rd Part of First  Circuit: OUTPUT
--Compinational OUTPUT

clk_one_sec<='1' when clk_counts=100000000 else '0';
--clk_one_sec<='1' when clk_counts=10 else '0';


------------------------------
------------------------------
--SECOND LOGIC CIRCUIT
--COUNTS UP/DOWN seconds 

--1st Part of Second Circuit: INPUT

process(clk_one_sec) is

begin

if (clk_one_sec='1') then 
--    report("1st sec_counts"&integer'image(sec_counts));
    if (direction='1' and sec_counts<99) then 
        new_sec_counts<= sec_counts+1; 
    elsif  (direction='0' and sec_counts>0) then
        new_sec_counts<= sec_counts-1;
    elsif  (direction='0' and sec_counts<=0) then
        new_sec_counts<= "1100011"; 
    elsif (direction='1' and sec_counts>=99) then
        new_sec_counts<="0000000"; 
    else
        new_sec_counts<="0000000";	
    end if;
--    report("2nd sec_counts"&integer'image(sec_counts));   
else
    new_sec_counts<=sec_counts;
end if;

end process;

--2nd Part of Second Circuit: STATE (Register)
--The Register
--HOLD the seconds!
                 
count_seconds: process (clk, reset) is

begin

if (reset='1') then

    sec_counts<=(others=>'0');
--sec_counts<=0;
elsif rising_edge(clk) then

    sec_counts<=new_sec_counts;

end if; --reset

end process count_seconds;


------------------------------
------------------------------
--THIRD LOGIC CIRCUIT
--Switch every 0.05 sec to each digit


digit_process: process (clk, reset) is

variable clk_ticks : integer;

begin

	if reset = '1' then
	
       clk_ticks :=0;
       digit_selection<='0';
--       seven_segment<=(others=>'0');
    
	elsif rising_edge(clk) then
	
		if clk_ticks = 500000 then
			clk_ticks := 0;
		    digit_selection<=not digit_selection;
--		    if digit_selection='0' then
--               	digit_selection<='1';
--               	seven_segment<=seven_segment_left;
--           else
--	           digit_selection<='0';
--	           seven_segment<=seven_segment_right;
--           end if;

		else
			clk_ticks := clk_ticks + 1;
			
		end if; -- clk_ticks
		
	end if; --reset
	
end process digit_process;


--3rd Part of Second  Circuit: OUTPUT
---- *************************
---- COMBINATIONAL FOR OUTPUT FOR WHOLE CIRCUIT
---- *************************

--LED Output
led_result<=std_logic_vector(sec_counts);      

----PMOD Output
left_digit<=resize(sec_counts/10, left_digit'length);       --Tens
right_digit<=resize(sec_counts mod 10, right_digit'length); --Units

left_digit_values: process (left_digit) begin

case left_digit is

    when X"0" => seven_segment_left   <="0111111";    -- 0
    when X"1" => seven_segment_left   <="0000110";    -- 1
    when X"2" => seven_segment_left   <="1011011";    -- 2
    when X"3" => seven_segment_left   <="1001111";    -- 3
    when X"4" => seven_segment_left   <="1100110";    -- 4
    when X"5" => seven_segment_left   <="1101101";    -- 5
    when X"6" => seven_segment_left   <="1111101";    -- 6
    when X"7" => seven_segment_left   <="0000111";    -- 7
    when X"8" => seven_segment_left   <="1111111";    -- 8
    when X"9" => seven_segment_left   <="1101111";    -- 9
    when others => seven_segment_left <="1000000";

end case;

end process left_digit_values;

-- create right Pmod digit
right_digit_values: process (right_digit) begin

case right_digit is

    when X"0" => seven_segment_right   <="0111111";    -- 0
    when X"1" => seven_segment_right   <="0000110";    -- 1
    when X"2" => seven_segment_right   <="1011011";    -- 2
    when X"3" => seven_segment_right   <="1001111";    -- 3
    when X"4" => seven_segment_right   <="1100110";    -- 4
    when X"5" => seven_segment_right   <="1101101";    -- 5
    when X"6" => seven_segment_right   <="1111101";    -- 6
    when X"7" => seven_segment_right   <="0000111";    -- 7
    when X"8" => seven_segment_right   <="1111111";    -- 8
    when X"9" => seven_segment_right   <="1101111";    -- 9
    when others => seven_segment_right <="1000000";
    
end case;

end process right_digit_values;


digit_selection_out<=digit_selection;

-- Pmod Digit Value
seven_segment<=seven_segment_right when digit_selection='0' else seven_segment_left when digit_selection='1' else (others=>'0');

end Behavioral;

