      REAL FUNCTION xyc(IPOS)
*
*     Corrections best applied for Tc99 data
*
*     IPOS=1 ==> xy = Xpos 
*     IPOS=2 ==> xy = Ypos 
*     IPOS=3 ==> xy = XposC
*     IPOS=4 ==> xy = YposC
*     IPOS=5 ==> xy = XposC+Rotation
*     IPOS=6 ==> xy = YposC+Rotation
*
      REAL
     +EVT     ,xa      ,xb      ,yc      ,yd       
*
      LOGICAL         CHAIN
      CHARACTER*128   CFILE
*
      COMMON /PAWCHN/ CHAIN, NCHEVT, ICHEVT
      COMMON /PAWCHC/ CFILE
*
      COMMON/PAWIDN/IDNEVT,OBS(13),
     +EVT     ,xa      ,xb      ,yc      ,yd       
*
      Ampl  =  1.000

*     Xorig = -0.000     ! Tc99    Gain 2 2 2 2
*     Xorig = -0.025     ! Cs137   Gain 1 1 1 1
*     Xorig = -0.025     ! Co60    Gain 0 0 0 0

      The   = -3.000
      Xorig = +0.030     
      Yorig =  0.000

      Theta = The * 0.017453

      If (IPOS.EQ.1.OR.IPOS.EQ.3) Then
          xxp = xb + Ampl*xa
          xxm = xb - Ampl*xa
    
          If (xxp.NE.0.0) Xpos = xxm/xxp
          If (xxp.EQ.0.0) Xpos = 0.0

          xyc = Xpos

      EndIf

*

      If (IPOS.EQ.2.OR.IPOS.EQ.4) Then
          yyp = yc + yd
          yym = yc - yd
    
          If (yyp.NE.0.0) Ypos = yym/yyp
          If (yyp.EQ.0.0) Ypos = 0.0

          xyc = Ypos

      EndIf

*

      If (IPOS.EQ.5) Then

          xxm = xb - Ampl*xa
          xxp = xb + Ampl*xa
          yym = yc - yd
          yyp = yc + yd
 
          If (xxp.NE.0.0) xxx=xxm/xxp
          If (xxp.EQ.0.0) xxx=0.0

          If (yyp.NE.0.0) yyy=yym/yyp
          If (yyp.EQ.0.0) yyy=0.0

          xx_n = xxx - Xorig
          yy_n = yyy - Yorig

          xxc = xx_n*cos(Theta)-yy_n*sin(Theta)
          yyc = xx_n*sin(Theta)+yy_n*cos(Theta)
  
          xyc = xxc

      EndIf

*
         
      If (IPOS.EQ.6) Then

          xxm = xb - Ampl*xa
          xxp = xb + Ampl*xa
          yym = yc - yd
          yyp = yc + yd
 
          If (xxp.NE.0.0) xxx=xxm/xxp
          If (xxp.EQ.0.0) xxx=0.0

          If (yyp.NE.0.0) yyy=yym/yyp
          If (yyp.EQ.0.0) yyy=0.0

          xx_n = xxx - Xorig
          yy_n = yyy - Yorig

          xxc = xx_n*cos(Theta)-yy_n*sin(Theta)
          yyc = xx_n*sin(Theta)+yy_n*cos(Theta)
  
          xyc = yyc

      EndIf
         
*

      END
